<?php

namespace App\Models\Edu\Device;

use App\Models\Site\SiteInfo;
use Illuminate\Database\Eloquent\Model;

class DeviceDetail extends Model
{
    protected $table = 'device_details';
    public $timestamps = true;



    const DEVICE_ID = 'device_id';
    const SITE_ID = 'site_id';
    const SET_UP_TIME = 'set_up_time';
    const LAST_PULLED_DATA_ID = 'last_pulled_data_id';
    const LAST_PULLED_DATA_TIME= 'last_pulled_data_time';
    const STATUS = 'status';


    protected $fillable = [
        self::DEVICE_ID,
        self::SITE_ID,
        self::SET_UP_TIME,
        self::LAST_PULLED_DATA_ID,
        self::LAST_PULLED_DATA_TIME,
        self::STATUS,
    ];

    public $ownFields = [
        self::DEVICE_ID,
        self::SITE_ID,
        self::SET_UP_TIME,
        self::STATUS,
    ];

    public function site()
    {
        return $this->belongsTo(SiteInfo::class,'site_id');
    }


}
