<?php

namespace App\Models\Edu\Device;

use App\Models\Site\SiteInfo;
use App\Models\User\GlobalUser;
use Illuminate\Database\Eloquent\Model;

class DeviceLog extends Model
{
    protected $table = 'edu_device_logs';
    public $timestamps = true;

    const LOG_ID = 'log_id';
    const DEVICE_ID = 'device_id';
    const USER_ID = 'user_biometric_id';
    const ACCESS_TIME = 'access_time';
    const ACCESS_DATE= 'access_date';
    const ACCESS_DATE_TIME= 'access_date_time';
    const EXECUTED_STATUS = 'executed_status';
    const STATUS = 'status';


    protected $fillable = [
        self::LOG_ID,
        self::DEVICE_ID,
        self::USER_ID,
        self::ACCESS_TIME,
        self::ACCESS_DATE,
        self::ACCESS_DATE_TIME,
        self::EXECUTED_STATUS,
        self::STATUS,
    ];

    public $ownFields = [
        self::LOG_ID,
        self::DEVICE_ID,
        self::USER_ID,
        self::ACCESS_TIME,
        self::ACCESS_DATE,
        self::ACCESS_DATE_TIME,
        self::EXECUTED_STATUS,
        self::STATUS,
    ];

    public function user()
    {
        return $this->belongsTo(GlobalUser::class,'user_biometric_id','username');
    }

}
