<?php

namespace App\Models\Edu;

use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class EduRole extends Model
{
    protected $table = 'edu_roles';
    public $timestamps = true;


    const NAME = 'name';
    const DESCRIPTION = 'description';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::DESCRIPTION,
        self::STATUS,
    ];

    public $ownFields = [
        self::NAME,
        self::DESCRIPTION,
        self::STATUS,
    ];


    public function setDescriptionAttribute($target){

        $this->attributes[self::DESCRIPTION] = $target ?: 'No Description';

    }


    public function groupAccess()
    {
        return $this->hasMany(EduRoleAccess::class);
    }


    /**
     * The users that belong to the role.
     */
    public function users()
    {
        return $this->belongsToMany(User::class,'edu_role_user', 'role_id', 'user_id');
    }

}
