<?php

namespace App\Models\Edu\Transaction;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use Illuminate\Database\Eloquent\Model;

class EduTransactionDetail extends Model
{
    protected $table = 'edu_transaction_details';

    protected $appends = array('loading_voucher_download');


    const Paid_amount = 'paid_amount';
    const Academic_online_payment_method_id = 'academic_online_payment_method_id';

    const Merchant_id = 'merchant_id';
    const Order_id = 'order_id';
    const Payment_ref_id = 'payment_ref_id';
    const Client_mobile_no = 'client_mobile_no';
    const Merchant_mobile_no = 'merchant_mobile_no';
    const Order_date_time = 'order_date_time';
    const Issuer_payment_date_time = 'issuer_payment_date_time';
    const Issuer_payment_ref_no = 'issuer_payment_ref_no';

    const Site_id = 'site_id';
    const STATUS = 'status';



    protected $fillable = [
        self::Site_id,
        self::Paid_amount,
        self::Academic_online_payment_method_id,

        self::Merchant_id,
        self::Order_id,
        self::Payment_ref_id,
        self::Client_mobile_no,
        self::Merchant_mobile_no,
        self::Order_date_time,
        self::Issuer_payment_date_time,
        self::Issuer_payment_ref_no,

        self::STATUS,
    ];


    public function academicOnlinePaymentMethod()
    {
        return $this->belongsTo(AcademicOnlinePaymentMethod::class);
    }

    public function eduStudentInvoice()
    {
        return $this->hasMany(EduStudentInvoice::class, 'order_id','order_id');
    }



    public function getLoadingVoucherDownloadAttribute()
    {
        return $this->attributes['loading_voucher_download'] = false;

    }



}
