<?php

namespace App\Models\Employee;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\ProjectModel;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeeSiteShift;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteEmployeeDepartmentClassSubject extends Model
{
    protected $table='site_emp_department_class_subjects';


    const User_id = 'user_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_subject_id = 'academic_subject_id';
    const Assign_date = 'assign_date';
    const Release_date = 'release_date';
    const Mejor = 'mejor';
    const Status = 'status';

    public $timestamps = true;


    protected $fillable = [
        self::User_id,
        self::Academic_group_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_subject_id,
        self::Assign_date,
        self::Release_date,
        self::Mejor,
        self::Status,
    ];


    protected $ownFields = [
        self::User_id,
        self::Academic_group_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_subject_id,
        self::Assign_date,
        self::Release_date,
        self::Mejor,
        self::Status,
    ];


    public function user()
    {
        return $this->belongsTo(Employee::class, 'user_id');
    }

    public function emClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }
    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }

    public function shift()
    {
        return $this->hasOne(SiteEmployeeSiteShift::class,'user_id','user_id');
    }

    public function emSubject()
    {
        return $this->belongsTo(AcademicSubject::class, 'academic_subject_id');
    }



}
