<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GroupSiteModel extends Model
{
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';


    /**
     * ProjectModel constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        $this->fillable[] = self::SITE_ID;
        $this->fillable[] = self::SITE_GROUP_ID;

        $this->{self::SITE_ID} = (int)session()->get('SITE_ID');
        $this->{self::SITE_GROUP_ID} = (int)session()->get('SITE_GROUP_ID');
        parent::__construct($attributes);

    }


    public function newQuery()
    {
        $site_id = (int)session()->get('SITE_ID');
        $site_group_id = (int)session()->get('SITE_GROUP_ID');

        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.site_id', $site_id)->where($tableName . '.site_group_id', $site_group_id);

        return $final;//$this->applyGlobalScopes($final);
    }
}
