<?php

namespace App\Models\Image;

use App\Models\ProjectModel;
//use App\Models\Student\Student;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\TC\SiteTcSetting;
use App\Models\Site\Web\AboutUs\AboutUs;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\User;
use App\Models\Event\Event;
use App\Models\Author\Author;

use Illuminate\Database\Eloquent\Model;

//class Photo extends ProjectModel
 class Photo extends Model
{

    const NAME = 'name';
    const EXTENSION = 'extension';
    const PATH = 'path';
    const USER = 'user_id';
    const IMAGEABLE_ID = 'imageable_id';
    const Imageable_type = 'imageable_type';


    public $timestamps = true;

    protected $fillable = [
        self::NAME,
        self::EXTENSION,
        self::PATH,
        self::USER
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function imageable()
    {
        return $this->morphTo();
    }

  /*  public function commentable()
    {
        return $this->morphTo();
    }*/

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function students()
    {
        return $this->belongsTo(User::class);
    }

    public function events()
    {
        return $this->belongsTo(Event::class);
    }
    public function aboutUs()
    {
        return $this->belongsTo(AboutUs::class);
    }
    public function classRoom()
    {
        return $this->belongsTo(ClassRoom::class);
    }
    public function siteExamQuestion()
    {
        return $this->belongsTo(SiteExamQuestion::class);
    }

    public function tcsettings()
    {
        return $this->belongsTo(SiteTcSetting::class);
    }

    public function authors()
    {
        return $this->belongsTo(Author::class);
    }
}
