<?php



namespace App\Models\JobApplication;

use App\Models\Image\Photo;
use App\Models\ProjectModel;


use Illuminate\Database\Eloquent\Model;

class JobApplication extends ProjectModel
{

    protected $table = 'job_applications';


    public const POSITION          = 'position';
    public const FULL_NAME         = 'fullName';
    public const EMAIL             = 'email';
    public const PHONE             = 'phone';
    public const ADDRESS           = 'address';
    public const EXPERIENCE        = 'experience';
    public const EDUCATION         = 'education';
    public const COVER_LETTER      = 'coverLetter';
    public const RESUME_FILE_NAME  = 'resumeFileName';
    public const RESUME_FILE       = 'resumeFile';

    public const SITE_ID           = 'site_id';


    protected $fillable = [
        self::POSITION,
        self::FULL_NAME,
        self::EMAIL,
        self::PHONE,
        self::ADDRESS,
        self::EXPERIENCE,
        self::EDUCATION,
        self::COVER_LETTER,
        self::RESUME_FILE_NAME,
        self::RESUME_FILE,

        self::SITE_ID,
    ];

    public function photos()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }
     public function latestPhoto()
    {
        return $this->morphOne(Photo::class, 'imageable')->orderBy('id', 'DESC');

    }
}
