<?php

namespace App\Models\Role;

use App\Models\Company\Role\CompanyRole;
use App\Models\Company\Role\CompanyRoleAccess;
use App\Models\Edu\EduRole;
use App\Models\Edu\EduRoleAccess;
use App\Models\Permission\Permission;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\Role\SiteRole;
use App\Models\SiteGroup\Role\SiteGroupRole;
use App\Models\SiteGroup\Role\SiteGroupRoleAccess;
use App\Models\SiteGroup\SiteGroupAccess;
use DB;
use Session;


trait HasRoles
{

    /**
     * A user may have multiple roles.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles($user_type = '')
    {

        $user_type = Session::get('USER_TYPE') ?? $user_type;

        //dd($user_type);

        if ($user_type == 'eduworld') {
            return $this->belongsToMany(EduRole::class, 'edu_role_user', 'user_id', 'role_id');
        } else if ($user_type == 'site') {
            return $this->belongsToMany(SiteRole::class, 'site_role_user', 'user_id', 'role_id');
        } else if ($user_type == 'site_group') {
            return $this->belongsToMany(SiteGroupRole::class, 'site_group_role_user', 'user_id', 'role_id');
        } else if ($user_type == 'company') {
            return $this->belongsToMany(CompanyRole::class, 'company_role_users', 'user_id', 'role_id');
        }
    }


    /**
     * A user may have multiple roles.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function eduRoles()
    {
        return $this->belongsToMany(EduRole::class, 'edu_role_user', 'user_id', 'role_id');
    }

    /**
     * A user may have multiple roles.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function companyRoles()
    {
        return $this->belongsToMany(CompanyRole::class, 'company_role_users', 'user_id', 'role_id');
    }

    /**
     * A user may have multiple roles.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function siteGroupRoles()
    {
        return $this->belongsToMany(SiteGroupRole::class, 'site_group_role_user', 'user_id', 'role_id');

    }

    /**
     * A user may have multiple roles.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function siteRoles()
    {
        return $this->belongsToMany(SiteRole::class,'site_role_user', 'user_id', 'role_id');
    }

    public function siteGlobalRoles()
    {
        return $this->belongsToMany(GlobalSiteRole::class,'site_role_user', 'user_id', 'role_id');
    }

    /**
     * Assign the given role to the user.
     *
     * @param string $role
     * @return mixed
     */
    public function assignRole($role)
    {
        return $this->roles()->save(
            Role::whereName($role)->firstOrFail()
        );
    }

    /**
     * Determine if the user has the given role.
     *
     * @param mixed $role
     * @return boolean
     */
    public function hasEduRole($role)
    {
        $roles = request()->user()->eduRoles;

        if (is_string($role)) {
            return $roles->contains('key', $role);
        }

        return false;
    }


    /**
     * Determine if the user has the given role.
     *
     * @param mixed $role
     * @return boolean
     */
    public function hasCompanyRole($role)
    {
        $roles = request()->user()->companyRoles;

        if (is_string($role)) {
            return $roles->contains('key', $role);
        }

        return false;
    }

    /**
     * Determine if the user has the given role.
     *
     * @param mixed $role
     * @return boolean
     */
    public function hasSiteGroupRole($role)
    {
        $roles = request()->user()->siteGroupRoles;
        if (is_string($role)) {
            return $roles->contains('key', $role);
        }

        return false;
    }

    /**
     * Determine if the user has the given role.
     *
     * @param mixed $role
     * @return boolean
     */
    public function hasSiteRole($role)
    {
        $roles = request()->user()->siteRoles;

        if (is_string($role)) {
            return $roles->contains('key', $role);
        }

        return false;
    }

    /**
     * Determine if the user may perform the given permission.
     *
     * @param Permission $permission
     * @return boolean
     */
    public function hasPermission(Permission $permission)
    {
        return $this->hasRole($permission->roles);
    }


    public function getSubModules($user_type1 = '', $role_ids = null)
    {
      //  return $user_type1;
        $roles = $role_ids ?? request()->user()->roles->pluck('id');
        $user_type = Session::get('USER_TYPE') ?? $user_type1;
        $get_accesses = null;

        if ($user_type == 'eduworld') {
            $get_accesses = EduRoleAccess::whereIn('edu_role_id', $roles)->pluck('sub_module_ids');

        } else if ($user_type == 'company') {
            $get_accesses = CompanyRoleAccess::whereIn('company_role_id', $roles)->pluck('sub_module_ids');

        } else if ($user_type == 'site_group') {
            $get_accesses = SiteGroupRoleAccess::whereIn('site_group_role_id', $roles)->pluck('sub_module_ids');

        } else if ($user_type == 'site') {
            $get_accesses = SiteRoleAccess::whereIn('site_role_id', $roles)->pluck('sub_module_ids');
        }

        $sub_module_ids = [];
        foreach ($get_accesses as $get_access) {
            $sub_module_ids = array_unique(array_merge($sub_module_ids, explode(',', $get_access)));
        }

        return $sub_module_ids;
    }

    public function getPaletteKeyIds($for)
    {
        $roles = request()->user()->roles->pluck('id');
        $user_type = Session::get('USER_TYPE');
        $get_accesses = null;

        if ($user_type == 'eduworld') {
            if (request()->user()->hasEduRole('administrator')) {
                $palette_key_ids = DB::table('edu_dashboard_palettes')
                    ->whereIn('palette_for', $for)
                    ->pluck('key_id')->toArray();

                return $palette_key_ids;
            } else {
                $get_accesses = EduRoleAccess::whereIn('edu_role_id', $roles)->pluck('dashboard_palettes');
            }

        } else if ($user_type == 'company') {

            $get_accesses = CompanyRoleAccess::whereIn('company_role_id', $roles)->pluck('dashboard_palettes');

        } else if ($user_type == 'site_group') {

            $get_accesses = SiteGroupRoleAccess::whereIn('site_group_role_id', $roles)->pluck('dashboard_palettes');

        } else if ($user_type == 'site') {
            $get_accesses = SiteRoleAccess::whereIn('site_role_id', $roles)->pluck('dashboard_palettes');
        }

        $key_ids = [];
        foreach ($get_accesses as $get_access) {
            $key_ids = array_unique(array_merge($key_ids, explode(',', $get_access)));
        }

        $palette_key_ids = DB::table('edu_dashboard_palettes')
            ->whereIn('palette_for', $for)
            ->whereIn('key_id', $key_ids)
            ->pluck('key_id')->toArray();


        return $palette_key_ids;
    }


}
