<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/3/2016
 * Time: 10:30 AM
 */
namespace App\Models\Room;

use App\Models\ProjectModel;
use App\Models\Timetable\TimetableWeekdayClasstimingHistory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Building\Building;
use App\Models\Floor\Floor;
use App\Models\Rack\Rack;
use App\Models\Routine\Routine;
use App\Models\Examinations\ExaminationSchedule;

class Room extends ProjectModel
{
    use SoftDeletes;

    public $timestamps = false;
    protected $table = 'site_rooms';
    protected $appends = array('room_name_ex');

    
    const BUILDING = 'building_id';
    const FLOOR = 'floor_id';
    const ROOM_NAME = 'room_name';
    const COLUMN_NUMBER = 'column_number';
    const DOOR_SEAT_ORIENTATION = 'door_seat_orientation';
    const Total_exam_seat = 'total_exam_seat';
    const STATUS = 'status';


    protected $fillable = [
        self::BUILDING,
        self::FLOOR,
        self::ROOM_NAME,
        self::COLUMN_NUMBER,
        self::DOOR_SEAT_ORIENTATION,
        self::Total_exam_seat,
        self::STATUS
    ];
    protected $dates = ['deleted_at'];


    //mutator
    public function getRoomNameExAttribute()
    {
        return  $this->attributes['room_name_ex']=  ($this->building->building_name ?? '') .' '.($this->floor->floor_name ?? '') .'('.$this->room_name.')';

    }




    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function building()
    {
        return $this->belongsTo(Building::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function floor()
    {
        return $this->belongsTo(Floor::class);
    }

    // Room hasMany Racks
    public function racks()
    {
        return $this->hasMany(Rack::class);
    }

    // Room hasMany Routines
    public function routines()
    {
        return $this->hasMany(Routine::class);
    }

    public function TimetableWeekdayClasstimingHistorys()
    {
        return $this->hasMany(TimetableWeekdayClasstimingHistory::class);
    }

    // Room hasMany ExaminationSchedule
    public function examinationSchedules()
    {
        return $this->hasMany(ExaminationSchedule::class);
    }
}