<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class AccountsVoucherDetails extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_voucher_details';

    const VOUCHER_NO = 'voucher_no';
    const VOUCHER_TYPE = 'voucher_type';
    const TRANSACTION_FOR = 'transaction_for';
    const COLLECTION_TYPE = 'collection_type';
    const TRANSACTION_AMOUNT = 'transaction_amount';
    const TRANSACTION_BY = 'transaction_by';
    const TRNASACTION_DATE = 'transaction_date';
    const TRANSACTION_NOTE = 'transaction_note';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';
    const FEE_START_DATE = 'fee_start_date';
    const FEE_END_DATE = 'fee_end_date';


    protected $fillable = [
        self::VOUCHER_NO,
        self::VOUCHER_TYPE,
        self::TRANSACTION_FOR,
        self::COLLECTION_TYPE,
        self::TRANSACTION_AMOUNT,
        self::TRANSACTION_BY,
        self::TRNASACTION_DATE,
        self::TRANSACTION_NOTE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
        self::FEE_START_DATE,
        self::FEE_END_DATE,

    ];

    public $ownFields = [
        self::VOUCHER_NO,
        self::VOUCHER_TYPE,
        self::TRANSACTION_FOR,
        self::COLLECTION_TYPE,
        self::TRANSACTION_AMOUNT,
        self::TRANSACTION_BY,
        self::TRNASACTION_DATE,
        self::TRANSACTION_NOTE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
        self::FEE_START_DATE,
        self::FEE_END_DATE,

    ];

    public function accounts()
    {
        return $this->hasMany(Accounts::class, 'site_accounts_voucher_detail_id');
    }

    public function siteAccountsVoucherDetailsStudentPaymentHistoryRecord()
    {
        return $this->hasMany(SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::class, 'site_accounts_voucher_detail_id');
    }

    public function siteAccountsVoucherDetailsBankAccountDepositRecord()
    {
        return $this->hasMany(SiteAccountsVoucherDetailsBankAccountDepositRecord::class, 'site_accounts_voucher_detail_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'transaction_by');
    }

    public function siteAccountsEmployeeSalary()
    {
        return $this->hasMany(SiteAccountsEmployeeSalary::class, 'site_accounts_voucher_detail_id');
    }

    public function siteAccountsBankAccountTransferCostRecord()
    {
        return $this->hasOne(SiteAccountsBankAccountTransferCostRecord::class, 'site_accounts_voucher_detail_id');
    }

    public function siteAccountsFixedAsset()
    {
        return $this->hasMany(SiteAccountsFixedAsset::class, 'site_accounts_voucher_detail_id');
    }

}
