<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class BankAccountDetails extends SiteGlobalModel
{

    public $timestamps = true;
    public $incrementing = false;
    protected $table='site_accounts_bank_account_details';

    const SITE_ACCOUNTS_BANK_ID = 'site_accounts_bank_id';
    const ACCOUNT_TYPE = 'account_type';
    const ACCOUNT_NUMBER = 'account_number';
    const ACCOUNT_BALANCE = 'account_balance';
    const ACCOUNT_OPENING_DATE = 'account_opening_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';

    protected $fillable = [
        self::SITE_ACCOUNTS_BANK_ID,
        self::ACCOUNT_TYPE,
        self::ACCOUNT_NUMBER,
        self::ACCOUNT_BALANCE,
        self::ACCOUNT_OPENING_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
        self::CREATED_BY,
        self::CREATED_DATE,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_BANK_ID,
        self::ACCOUNT_TYPE,
        self::ACCOUNT_NUMBER,
        self::ACCOUNT_BALANCE,
        self::ACCOUNT_OPENING_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
        self::CREATED_BY,
        self::CREATED_DATE,

    ];
    public function chequeRegister()
    {
        return $this->hasMany(ChequeRegister::class);
    }

    public function chequeRegisterForLedgerAccounts()
    {
        return $this->hasMany(ChequeRegister::class, 'site_accounts_bank_account_detail_id');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class,'site_accounts_bank_id');
    }

    public function ledger()
    {
        return $this->belongsTo(Ledger::class, 'site_accounts_bank_id');
    }

    public function siteAccountsVoucherDetailsBankAccountDepositRecord()
    {
        return $this->hasMany(SiteAccountsVoucherDetailsBankAccountDepositRecord::class ,'site_accounts_bank_account_detail_id');
    }
}
