<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsBankAccountTransferCostRecord extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_bank_account_transfer_cost_records';

    const SITE_ACCOUNTS_VOUCHER_DETAIL_ID = 'site_accounts_voucher_detail_id';
    const SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID = 'site_accounts_bank_account_detail_id';
    const TRANSACTION_COST = 'transaction_cost';
    const TRANSACTION_DATE = 'transaction_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::TRANSACTION_COST,
        self::TRANSACTION_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::TRANSACTION_COST,
        self::TRANSACTION_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function accountsVoucherDetails()
    {
        return $this->hasMany(AccountsVoucherDetails::class);
    }
}
