<?php

namespace App\Models\Site\Accounts;

use App\Models\Academic\AcademicMonthName;
use App\Models\SiteGlobalModel;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsEmployeeSalary extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_employee_salaries';

    const EMPLOYEE_ID = 'employee_id';
    const MONTH_ID = 'month_id';
    const SITE_ACCOUNTS_VOUCHER_DETAILS_ID = 'site_accounts_voucher_detail_id';
    const PAYMENT_TYPE = 'payment_type';
    const AMOUNT = 'amount';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::EMPLOYEE_ID,
        self::MONTH_ID,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::PAYMENT_TYPE,
        self::AMOUNT,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::EMPLOYEE_ID,
        self::MONTH_ID,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::PAYMENT_TYPE,
        self::AMOUNT,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function accounts()
    {
        return $this->belongsTo(AccountsVoucherDetails::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }

    public function academicMonthName()
    {
        return $this->belongsTo(AcademicMonthName::class, 'month_id');
    }
}
