<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsFixedAsset extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_fixed_assets';

    const ASSET_TYPE = 'asset_type';
    const ITEM_NAME = 'item_name';
    const ITEM_CODE = 'item_code';
    const UNIT_PRICE = 'unit_price';
    const QTY = 'qty';
    const PURCHASE_COST = 'purchase_cost';
    const SITE_ACCOUNTS_VOUCHER_DETAILS_ID = 'site_accounts_voucher_detail_id';
    const PURCHASE_DATE = 'purchase_date';
    const DEPRICATION_STATUS = 'depriciation_status';
    const AMORTIZATION_STATUS = 'amortization_status';
    const DEPRICIATION_TYPE = 'depriciation_type';
    const AMORTIZATION_TYPE = 'amortization_type';
    const COUNT_TYPE = 'count_type';
    const DEPRICIATION_AMOUNT = 'depriciation_amount';
    const AMORTIZATION_AMOUNT = 'amortization_amount';
    const LIFE_TIME = 'life_time';
    const LIFE_TIME_CALCULATION_METHOD = 'life_time_calculation_method';
    const ACTIVE_DATE = 'active_date';
    const EXPENSE_LEDGER_ID = 'expense_ledger_id';
    const NARRATION = 'narration';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';




    protected $fillable = [
        self::ASSET_TYPE,
        self::ITEM_NAME,
        self::ITEM_CODE,
        self::UNIT_PRICE,
        self::QTY,
        self::PURCHASE_COST,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::PURCHASE_DATE,
        self::DEPRICATION_STATUS,
        self::AMORTIZATION_STATUS,
        self::DEPRICIATION_TYPE,
        self::AMORTIZATION_TYPE,
        self::COUNT_TYPE,
        self::DEPRICIATION_AMOUNT,
        self::AMORTIZATION_AMOUNT,
        self::LIFE_TIME,
        self::LIFE_TIME_CALCULATION_METHOD,
        self::ACTIVE_DATE,
        self::EXPENSE_LEDGER_ID,
        self::NARRATION,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public $ownFields = [
        self::ASSET_TYPE,
        self::ITEM_NAME,
        self::ITEM_CODE,
        self::UNIT_PRICE,
        self::QTY,
        self::PURCHASE_COST,
        self::SITE_ACCOUNTS_VOUCHER_DETAILS_ID,
        self::PURCHASE_DATE,
        self::DEPRICATION_STATUS,
        self::AMORTIZATION_STATUS,
        self::DEPRICIATION_TYPE,
        self::AMORTIZATION_TYPE,
        self::COUNT_TYPE,
        self::DEPRICIATION_AMOUNT,
        self::AMORTIZATION_AMOUNT,
        self::LIFE_TIME,
        self::LIFE_TIME_CALCULATION_METHOD,
        self::ACTIVE_DATE,
        self::EXPENSE_LEDGER_ID,
        self::NARRATION,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function accountsVoucherDetails()
    {
        return $this->belongsTo(AccountsVoucherDetails::class);
    }
}
