<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsVoucherDetailsBankAccountDepositRecord extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_voucher_details_bank_account_deposit_records';

    const SITE_ACCOUNTS_VOUCHER_DETAIL_ID = 'site_accounts_voucher_detail_id';
    const SITE_ACCOUNT_ID = 'site_account_id';
    const SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID = 'site_accounts_bank_account_detail_id';
    const DEPOSIT_AMOUNT = 'deposit_amount';
    const WITHDRAW_AMOUNT = 'withdraw_amount';
    const TRANSACTION_DATE = 'transaction_date';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNT_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::DEPOSIT_AMOUNT,
        self::TRANSACTION_DATE,
        self::WITHDRAW_AMOUNT,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNT_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::DEPOSIT_AMOUNT,
        self::WITHDRAW_AMOUNT,
        self::TRANSACTION_DATE,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function accountsVoucherDetails()
    {
        return $this->belongsTo(AccountsVoucherDetails::class , 'site_accounts_voucher_detail_id');
    }

    public function BankAccountDetails()
    {
        return $this->belongsTo(BankAccountDetails::class, 'site_accounts_bank_account_detail_id');
    }
    public function accounts()
    {
        return $this->belongsTo(Accounts::class);
    }
}
