<?php

namespace App\Models\Site\Assessment;

use App\Models\Assessment\AssessmentTypeNo;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;

class SiteAssessmentDeclareStudentSubject extends SiteGlobalModel
{
    protected $table='site_assessment_declare_student_subjects';

    protected $appends = array('loading_show');

    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';

    const Site_assessment_declare_id = 'site_assessment_declare_id';
    const Site_assessment_declare_student_id = 'site_assessment_declare_student_id';
    const Student_history_id = 'student_history_id';
    const Site_assessment_routine_id = 'site_assessment_routine_id';
    const Assessment_id = 'assessment_id';
    const Expertise_id = 'expertise_id';
    const Assessment_type_id = 'assessment_type_id';
    const Assessment_type_no_id = 'assessment_type_no_id';

    const Assessment_attendance_status = 'assessment_attendance_status';
    const Assessment_held_status = 'assessment_held_status';
    const Column_position = 'column_position';

    const Assessment_type_no_mark = 'assessment_type_no_mark';
    const Mark_text_value = 'mark_text_value';
    const Mark_number_value = 'mark_number_value';
    const Site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';
    const Subject_topic_id = 'subject_topic_id';

    const Attendance_submit_by = 'attendance_submit_by';
    const Attendance_submit_by_machine = 'attendance_submit_by_machine';
    const Attendance_update_at = 'attendance_update_at';

    const Status = 'status';

    const Marks_input_permission = 'marks_input_permission';
    const Marks_input_by = 'marks_input_by';
    const Marks_last_update_by = 'marks_last_update_by';


    protected $fillable = [
        self::Site_assessment_declare_id,
        self::Site_assessment_declare_student_id,
        self::Site_assessment_routine_id,
        self::Student_history_id,
        self::Site_subject_group_condition_setting_id,
        self::Subject_topic_id,

        self::Assessment_attendance_status,
        self::Assessment_held_status,

        self::Assessment_id,
        self::Expertise_id,
        self::Assessment_type_id,
        self::Assessment_type_no_id,
        self::Assessment_type_no_mark,
        self::Mark_text_value,
        self::Mark_number_value,
        self::Site_id,
        self::Status,

        self::Column_position,
        self::Attendance_submit_by,
        self::Attendance_submit_by_machine,
        self::Attendance_update_at,

        self::Marks_input_permission,
        self::Marks_input_by,
        self::Marks_last_update_by,

    ];

 
    //mutator
    public function getLoadingShowAttribute()
    {
        return $this->attributes['loading_show'] = false;

    }

    public function testArray($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = SiteAssessmentDeclareStudentSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

 
    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);

    }
    public function assessmentTypeNo()
    {
        return $this->belongsTo(AssessmentTypeNo::class);

    }

    public function routine()
    {
        return $this->belongsTo(SiteAssessmentRoutine::class, 'site_assessment_routine_id');
    }

   
    public function subjectGroupConditionSetting()
    {
        return $this->belongsTo(SubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');

    }

    public function marksInputBy()
    {
        return $this->belongsTo(Employee::class, 'marks_input_by');
    }

    public function marksLastUpdateBy()
    {
        return $this->belongsTo(Employee::class, 'marks_last_update_by');
    }

}
