<?php

namespace App\Models\Site\Assessment;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;

class SiteClassSubjectAssessmentTopic extends SiteGlobalModel
{
    //
    protected $table = 'site_class_subject_assessment_topics';

    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_subject_id = 'academic_subject_id';
    const Topic_name = 'topic_name';
    const STATUS = 'status';


    protected $fillable = [
        self::Site_id,
        self::Academic_group_id,
        self::Academic_version_id,
        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,
        self::Academic_subject_id,
        self::Topic_name,
    ];

    public $ownFields = [
        self::Site_id,
        self::Academic_group_id,
        self::Academic_version_id,
        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,
        self::Academic_subject_id,
        self::Topic_name,
    ];

    public function subject()
    {
        return $this->belongsTo(AcademicSubject::class, self::Academic_subject_id);
    }

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }


    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    public function class()
    {
        return $this->belongsTo(AcademicClass::class, self::Academic_class_id);
    }


}
