<?php

namespace App\Models\Site\Employee;

use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class TeacherAssignToClassSection extends SiteGlobalModel
{

    public $timestamps = true;
    protected $table = 'teacher_assign_to_class_sections';

    const EMPLOYEE_HISTORY_ID = 'employee_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_DEPARMENT_ID = 'academic_department_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ASSIGN_DATE = 'assign_date';
    const ASSIGN_BY = 'assigned_by';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const SITE_GROUP_ID = 'site_group_id';
    const STATUS = 'status';

    protected $fillable = [
        self::EMPLOYEE_HISTORY_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ASSIGN_DATE,
        self::ASSIGN_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::EMPLOYEE_HISTORY_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ASSIGN_DATE,
        self::ASSIGN_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
    ];


}