<?php
namespace App\Models\Site\EmployeeDuty;

use App\Models\Site\SiteInfo;
use App\Models\User\EmployeeHistory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SiteEmployeeAssignDutyHistory extends Model
{


    // Table name (if it doesn't follow the Laravel convention)
    protected $table = 'site_employee_assign_duty_histories';

    // Mass-assignable attributes
    protected $fillable = [
        'employee_history_id',
        'start_time',
        'end_time',
        'selected_week',
        'reason',
    ];

    // Relationships
    public function employee()
    {
        return $this->belongsTo(EmployeeHistory::class);
    }

    public function site()
    {
        return $this->belongsTo(SiteInfo::class);
    }
}
