<?php

namespace App\Models\Site\EmployeeLeave;

use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Designation\Designation;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteLeavePolicy extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_leave_policies';

    const ACADEMIC_LEAVE_TYPE_ID = 'academic_leave_type_id';
    const ACADEMIC_LEAVE_CATEGORY_ID = 'academic_leave_category_id';
    const POLICY_TITLE = 'policy_title';
    const LEAVE_DAYS = 'leave_days';
    const ADD_TO_NEXT_YEAR = 'add_to_next_year';
    const WAGES_PAYABLE = 'wages_payable';
    const EMPLOYEE_DESIGNATION_ID = 'employee_designation_id';
    const POLICY_DETAILS = 'policy_details';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const GENDER_ID = 'gender_id';
    const MULTIPLE_GENERATE = 'multiple_generate';
    const STATUS = 'status';


    protected $fillable = [
        self::ACADEMIC_LEAVE_TYPE_ID,
        self::ACADEMIC_LEAVE_CATEGORY_ID,
        self::POLICY_TITLE,
        self::LEAVE_DAYS,
        self::ADD_TO_NEXT_YEAR,
        self::WAGES_PAYABLE,
        self::EMPLOYEE_DESIGNATION_ID,
        self::POLICY_DETAILS,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::GENDER_ID,
        self::MULTIPLE_GENERATE,
        self::STATUS
    ];

    public $ownFields = [
        self::ACADEMIC_LEAVE_TYPE_ID,
        self::ACADEMIC_LEAVE_CATEGORY_ID,
        self::POLICY_TITLE,
        self::LEAVE_DAYS,
        self::ADD_TO_NEXT_YEAR,
        self::WAGES_PAYABLE,
        self::EMPLOYEE_DESIGNATION_ID,
        self::POLICY_DETAILS,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::GENDER_ID,
        self::MULTIPLE_GENERATE,
        self::STATUS
    ];

    public function designation()
    {
        return $this->belongsTo(Designation::class, 'employee_designation_id');
    }
    public function academicLeaveType()
    {
        return $this->belongsTo(AcademicLeaveType::class);
    }
    public function academicLeaveCategory()
    {
        return $this->belongsTo(AcademicLeaveCategory::class);
    }

    public function siteEmployeeLeaveGenerate()
    {
        return $this->belongsTo(SiteEmployeeLeaveGenerate::class);
    }
}
