<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Attendance\StudentAttendance;
use App\Models\Examinations\Examination;
use App\Models\ProjectModel;
use App\Models\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\Site\Exam\SiteExamRoutine;

use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteExamDeclareStudentSubject extends Model
{
    protected $table='site_exam_declare_student_subjects';

    protected $appends = array('loading_show');

    const Site_exam_declare_id = 'site_exam_declare_id';
    const Site_exam_declare_student_id = 'site_exam_declare_student_id';
    const Student_history_id = 'student_history_id';
    const Site_exam_routine_id = 'site_exam_routine_id';
    const Examination_id = 'examination_id';
    const Academic_exam_type_id = 'academic_exam_type_id';

    const Exam_attendance_status = 'exam_attendance_status';
    const Exam_held_status = 'exam_held_status';

    const Obtaine_marks = 'obtaine_marks';
    const Grace_marks = 'grace_marks';
    const Pass_mark = 'pass_mark';
   
    const Exam_type_countable_marks_status = 'exam_type_countable_marks_status';
    const Exam_type_countable_marks = 'exam_type_countable_marks';
    const Exam_type_countable_persent_of_obtain_marks = 'exam_type_countable_persent_of_obtain_marks';
    
    const Subject_exam_type_mark = 'subject_exam_type_mark';
    const Site_subject_examination_mark_id = 'site_subject_examination_mark_id';
    const Site_subject_examination_exam_type_mark_id = 'site_subject_examination_exam_type_mark_id';
    const Site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';

    const Site_base_exam_room_setting_id = 'site_base_exam_room_setting_id';
    const Room_id = 'room_id';
    const Column_position = 'column_position';
    const Seat_number = 'seat_number';

    const Academic_seat_plan_type_id = 'academic_seat_plan_type_id';
    const Academic_seat_plan_style_id = 'academic_seat_plan_style_id';

    const Attendance_submit_by = 'attendance_submit_by';
    const Attendance_submit_by_machine = 'attendance_submit_by_machine';
    const Attendance_update_at = 'attendance_update_at';



    const Online_exam_status = 'online_exam_status';
    const Online_exam_time = 'online_exam_time';
    const Online_exam_time_left = 'online_exam_time_left';
    const Online_exam_present_by_student = 'online_exam_present_by_student';
    const Online_exam_start_by_teacher = 'online_exam_start_by_teacher';
    const Online_exam_start = 'online_exam_start';
    const Online_exam_start_time = 'online_exam_start_time';
    const Online_exam_end = 'online_exam_end';
    const Online_exam_end_time = 'online_exam_end_time';
    const Online_exam_pause = 'online_exam_pause';
    const Online_exam_pause_time = 'online_exam_pause_time';
    const Online_exam_apply_for_restart = 'online_exam_apply_for_restart';
    const Online_exam_restart_apply_time = 'online_exam_restart_apply_time';
    const Online_exam_restart_apply_amount = 'online_exam_restart_apply_amount';
    const Online_exam_restart_approve = 'online_exam_restart_approve';



    const Site_id = 'site_id';
    const Status = 'status';

    const Marks_input_by = 'marks_input_by';
    const Marks_last_update_by = 'marks_last_update_by';


    protected $fillable = [
        self::Site_exam_declare_id,
        self::Site_exam_declare_student_id,
        self::Student_history_id,
        self::Site_subject_group_condition_setting_id,

        self::Exam_attendance_status,
        self::Exam_held_status,
        self::Grace_marks,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Site_id,
        self::Status,

        self::Site_base_exam_room_setting_id,
        self::Room_id,
        self::Column_position,
        self::Seat_number,
        self::Attendance_submit_by,

        self::Marks_input_by,
        self::Marks_last_update_by,

        self::Exam_type_countable_marks_status,
        self::Exam_type_countable_marks,
        self::Exam_type_countable_persent_of_obtain_marks,

    ];

    protected $ownFields = [
        self::Site_exam_declare_id,
        self::Site_exam_declare_student_id,
        self::Student_history_id,
        self::Site_subject_group_condition_setting_id,

        self::Exam_attendance_status,
        self::Exam_held_status,
        self::Grace_marks,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Site_id,
        self::Status,

        self::Site_base_exam_room_setting_id,
        self::Room_id,
        self::Column_position,
        self::Seat_number,
        self::Attendance_submit_by,


        self::Marks_input_by,
        self::Marks_last_update_by,

        self::Exam_type_countable_marks_status,
        self::Exam_type_countable_marks,
        self::Exam_type_countable_persent_of_obtain_marks,

    ];


    //mutator
    public function getLoadingShowAttribute()
    {
        return $this->attributes['loading_show'] = false;

    }

    public function getExamAttendanceStatusAttribute($values)
    {

        return $this->attributes['exam_attendance_status'] = $values?true:false;

    }

    public function getExamHeldStatusAttribute($values)
    {

        return $this->attributes['exam_held_status'] = $values?true:false;

    }

    public function testArray($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = SiteExamDeclareStudentSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

    // public function getCompulsorySubjectIdsAttribute($value)
    // {
    //     $arr = $value ? array_map('intval', explode(',', $value)) : [];
    //     $array = AcademicSubject::whereIn('id', $arr)->get();
    //     return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    // }
    public function sameSubject()
    {
        return $this->hasMany(SiteExamDeclareStudentSubject::class,'academic_exam_type_id','academic_exam_type_id');

    }
    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);

    }

    public function attendance()
    {
        return $this->hasOne(StudentAttendance::class, 'student_history_id', 'student_history_id');
    }
    public function routine()
    {
        return $this->belongsTo(SiteExamRoutine::class, 'site_exam_routine_id');
    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);

    }
    public function subjectGroupConditionSetting()
    {
        return $this->belongsTo(SubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');

    }
    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class,'academic_exam_type_id');
    }

   
    // public function academicExamTypetest()
    // {
    //     return $this->hasMany(AcademicExamType::where('id','academic_exam_type_id'));

    // }

    public function siteSubjectExaminationMark()
    {
        return $this->hasMany(SiteSubjectExaminationMark::class, 'site_subject_group_condition_setting_id', 'site_subject_group_condition_setting_id');
    }



    public function marksInputBy()
    {
        return $this->belongsTo(Employee::class, 'marks_input_by');
    }

    public function marksLastUpdateBy()
    {
        return $this->belongsTo(Employee::class, 'marks_last_update_by');
    }




}
