<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\ProjectModel;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteExamRoutine extends Model
{
    protected $table='site_exam_routines';
    protected $appends = array('examination_name', 'exam_type_name');

    const Academic_group_id = 'academic_group_id';
    const Site_exam_declare_id = 'site_exam_declare_id';
    const Site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';
    const Academic_exam_type_id = 'academic_exam_type_id';
    const Exam_start_date = 'exam_start_date';
    const Exam_end_date = 'exam_end_date';
    const Exam_start_time = 'exam_start_time';
    const Exam_end_time = 'exam_end_time';
    const Exam_duration = 'exam_duration';
    const Per_day_student = 'per_day_student';
    const Site_id = 'site_id';
    const Status = 'status';


    protected $fillable = [
        self::Academic_group_id,
        self::Site_exam_declare_id,
        self::Site_subject_group_condition_setting_id,
        self::Academic_exam_type_id,
        self::Exam_start_date,
        self::Exam_end_date,
        self::Exam_start_time,
        self::Exam_end_time,
        self::Exam_duration,
        self::Per_day_student,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::Academic_group_id,
        self::Site_exam_declare_id,
        self::Site_subject_group_condition_setting_id,
        self::Academic_exam_type_id,
        self::Exam_start_date,
        self::Exam_end_date,
        self::Exam_start_time,
        self::Exam_end_time,
        self::Exam_duration,
        self::Per_day_student,
        self::Site_id,
        self::Status,

    ];

    public function getExaminationNameAttribute() {

        return  $this->attributes['examination_name']=  $this->examination->examination_name;

    }

    public function getExamTypeNameAttribute() {

        return  $this->attributes['exam_type_name']=  $this->academicExamType->marks_type;

    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);

    }


    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class);

    }

    
    public function globalSubjectGroupConditionSetting()
    {
        return $this->belongsTo(GlobalSubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');

    }
}
