<?php

namespace App\Models\Site\Exam;

use App\Models\ProjectModel;
use App\Models\Room\Room;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteExamInvigilatorRoomSetup extends ProjectModel
{
    protected $table='site_exam_invigilator_room_setups';



    const User_id = 'user_id';
    const Room_id = 'room_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Examination_id = 'examination_id';
    const Exam_start_date = 'exam_start_date';
    const Exam_start_time = 'exam_start_time';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::User_id,
        self::Room_id,
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Examination_id,
        self::Exam_start_date,
        self::Exam_start_time,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::User_id,
        self::Room_id,
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Examination_id,
        self::Exam_start_date,
        self::Exam_start_time,
        self::Site_id,
        self::Status,
    ];


    public function activeEmployee()
    {
        return $this->belongsTo(User::class, 'user_id')->select('id', 'contact_number')->where('status', true);
    }

    public function rooms()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

}
