<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteExaminationExamTypeSetting extends SiteGlobalModel
{
    protected $table='site_examination_exam_type_settings';
    protected $appends = array('examination_name');

    const Academic_group_id = 'academic_group_id';

    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_department_id = 'academic_department_id';

    const Examination_id = 'examination_id';
    const Academic_exam_type_id = 'academic_exam_type_id';
    const Direct_result_input = 'direct_result_input';
    const Retack_allow = 'retack_allow';
    const Exam_day = 'exam_day';
    const Position_show = 'position_show';
    const Type_access_owner = 'type_access_owner';
    const Admit_card_permission_with_due_payment = 'admit_card_permission_with_due_payment';
    const Status = 'status';

    const Routine_wise_exam_attendace = 'routine_wise_exam_attendace';
    const Examiner_exam_mark_entry_permission = 'examiner_exam_mark_entry_permission';
    const Exam_mark_entry_deadline = 'exam_mark_entry_deadline';

    
    protected $fillable = [
        self::Academic_group_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Direct_result_input,
        self::Retack_allow,
        self::Exam_day,
        self::Position_show,
        self::Type_access_owner,
        self::Admit_card_permission_with_due_payment,
        self::Status,

        self::Routine_wise_exam_attendace,
        self::Examiner_exam_mark_entry_permission,
        self::Exam_mark_entry_deadline,


    ];

    protected $ownFields = [
        self::Academic_group_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Academic_department_id,

        self::Examination_id,
        self::Academic_exam_type_id,
        self::Direct_result_input,
        self::Retack_allow,
        self::Exam_day,
        self::Position_show,
        self::Type_access_owner,
        self::Admit_card_permission_with_due_payment,
        self::Status,

        self::Routine_wise_exam_attendace,
        self::Examiner_exam_mark_entry_permission,
        self::Exam_mark_entry_deadline,
    ];



    //mutator
    public function getExaminationNameAttribute()
    {
        return  $this->attributes['examination_name']= $this->examination->examination_name;

    }


    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class);
    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }
}
