<?php

namespace App\Models\Site\Exam;

use App\Models\Examinations\Examination;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
 use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Database\Eloquent\Model;

class SiteSubjectExaminationMark extends SiteGlobalModel
{
    protected $table='site_subject_examination_marks';

    const Site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';
    const Examination_id = 'examination_id';
    const Marks = 'marks';
    const Pass_marks = 'pass_marks';
    const Academic_group_id = 'academic_group_id';
    const Status = 'status';

    


    protected $fillable = [
        self::Site_subject_group_condition_setting_id,
        self::Examination_id,
        self::Marks,
        self::Pass_marks,
        self::Academic_group_id,
        self::Status,
    ];

    protected $ownFields = [
        self::Site_subject_group_condition_setting_id,
        self::Examination_id,
        self::Marks,
        self::Pass_marks,
        self::Academic_group_id,
        self::Status,
    ];


    public function siteSubjectExaminationExamTypeMark()
    {
        return $this->hasMany(SiteSubjectExaminationExamTypeMark::class, 'site_subject_examination_mark_id');
    }

    public function subjectGroupConditionSetting()
    {
        return $this->belongsTo(SubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');
    }
    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }



}
