<?php

namespace App\Models\Site\Fee\Fine;

use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeFine extends SiteGlobalModel
{


    public $timestamps = true;
    protected $table='site_student_fee_fines';

    const SITE_STUDENT_FEE_DEMAND_SLIP_DETAILS_ID = 'site_student_fee_demand_slip_details_id';
    const FINE_AMOUNT = 'fine_amount';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const SITE_STUDENT_FEE_PAYMENT_HISTORY_ID = 'site_student_fee_payment_history_id';
    const FINE_TYPE = 'fee_type';
    const STATUS = 'status';
    const ACCOUNTS_RECEIVED_STATUS = 'accounts_received_status';
    const SITE_STUDENT_FEE_FINE_ID = 'site_student_fee_fine_id';
    const CREATED_DATE = 'created_date';


    protected $fillable = [
        self::SITE_STUDENT_FEE_DEMAND_SLIP_DETAILS_ID,
        self::FINE_AMOUNT,
        self::STUDENT_HISTORY_ID,
        self::SITE_STUDENT_FEE_PAYMENT_HISTORY_ID,
        self::STATUS,
        self::FINE_TYPE,
        self::ACCOUNTS_RECEIVED_STATUS,
        self::SITE_STUDENT_FEE_FINE_ID,
        self::CREATED_DATE,
    ];

    public $ownFields = [
        self::SITE_STUDENT_FEE_DEMAND_SLIP_DETAILS_ID,
        self::FINE_AMOUNT,
        self::STUDENT_HISTORY_ID,
        self::SITE_STUDENT_FEE_PAYMENT_HISTORY_ID,
        self::STATUS,
        self::FINE_TYPE,
        self::ACCOUNTS_RECEIVED_STATUS,
        self::SITE_STUDENT_FEE_FINE_ID,
        self::CREATED_DATE,
    ];

    public function siteStudentFeeDemandSlipDetails()
    {
        return $this->belongsTo(SiteStudentFeeDemandSlipDetails::class);
    }


}
