<?php

namespace App\Models\Site\StudentPaySlip;

use App\Models\Permission\GlobalGroupAccess;
use App\Models\Site\SiteStudentPaymentHistory;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeVoucher extends SiteGlobalModel
{

    public $timestamps = true;
    protected $table='site_student_fee_voucher';

    const VOUCHER_NO = 'voucher_no';
    const TOTAL_AMOUNT = 'total_amount';
    const PAID_AMOUNT = 'paid_amount';
    const DUE = 'due';
    const TAKEN_BY = 'taken_by';
    const PAYMENT_STATUS = 'payment_status';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const SITE_GROUP_ID = 'site_group_id';
    const STATUS = 'status';

    protected $fillable = [
        self::VOUCHER_NO,
        self::TOTAL_AMOUNT,
        self::PAID_AMOUNT,
        self::DUE,
        self::TAKEN_BY,
        self::PAYMENT_STATUS,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::STATUS
    ];

    public $ownFields = [
        self::VOUCHER_NO,
        self::TOTAL_AMOUNT,
        self::PAID_AMOUNT,
        self::DUE,
        self::TAKEN_BY,
        self::PAYMENT_STATUS,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::SITE_GROUP_ID,
        self::STATUS
    ];


    public function paymentHistories()
    {
        return $this->hasMany(SiteStudentPaymentHistory::class,'voucher_no');
    }

}
