<?php

namespace App\Models\Site\Fee;

use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeWaiverOfferHistory extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_fee_waiver_offer_histories';


    const Student_history_id = 'student_history_id';
    const Site_student_fee_fine_allocation_id = 'site_student_fee_fine_allocation_id';
    const Academic_waiver_type_id = 'academic_waiver_type_id';
    const Demand_slip_create_status = 'demand_slip_create_status';
    const Site_student_fee_waiver_document_id = 'site_student_fee_waiver_document_id';
    const Site_student_offer_id = 'site_student_offer_id';
    const Amount = 'amount';
    const Academic_fee_head_id = 'academic_fee_head_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Status = 'status';
    const Percantage_status = 'percantage_status';
    const Remark = 'remark';
    const Site_id = 'site_id';
    const Site_group_id = 'site_group_id';

    protected $fillable = [
        self::Student_history_id,
        self::Site_student_fee_fine_allocation_id,
        self::Academic_waiver_type_id,
        self::Demand_slip_create_status,
        self::Site_student_fee_waiver_document_id,
        self::Site_student_offer_id,
        self::Amount,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::Status,
        self::Percantage_status,
        self::Remark,
        self::Site_id,
        self::Site_group_id,

    ];

    public $ownFields = [
        self::Student_history_id,
        self::Site_student_fee_fine_allocation_id,
        self::Academic_waiver_type_id,
        self::Demand_slip_create_status,
        self::Site_student_fee_waiver_document_id,
        self::Site_student_offer_id,
        self::Amount,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::Status,
        self::Percantage_status,
        self::Remark,
        self::Site_id,
        self::Site_group_id,

    ];

    public function siteStudentFeeFineAllocation()
    {
        return $this->belongsTo(SiteStudentFeeFineAllocation::class);
    }


}
