<?php

namespace App\Models\Site\Log;

use App\Models\User\GlobalUser;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    protected $table='site_audit_logs';
    protected $fillable = [
        'description',
        'subject_id',
        'subject_type',
        'user_id',
        'properties',
        'site_id',
        'host',
    ];

    protected $casts = [
        'properties' => 'collection',
    ];



    public function user(){
     return   $this->belongsTo(GlobalUser::class);
    }
}
