<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 5/16/16
 * Time: 2:32 PM
 */

namespace App\Models\Site\Notice;


use App\Models\Image\Photo;
use App\Models\ProjectModel;
use Dimsav\Translatable\Translatable;

class Notice extends ProjectModel
{
    use  Translatable;

    public $timestamps = true;
    protected $table = 'site_notices';
    protected $dates = ['created_at','web_publish_time'];

    protected $casts = ['status' => 'integer'];

    const NOTICE_TITLE = 'notice_title';
    const NOTICE_DESCRIPTION = 'notice_description';
    const DOC_NUMBER = 'doc_number';
    const PUBLISH_TIME = 'web_publish_time';
    const PUBLISH_BY = 'web_publish_by';
    const TYPE = 'type';
    const CREATED_BY = 'created_by';
    const STATUS = 'status';
    const Pin_status = 'pin_status';
    const SITE_ID = 'site_id';




    protected $fillable = [
        self::NOTICE_TITLE,
        self::NOTICE_DESCRIPTION,
        self::TYPE,
        self::PUBLISH_TIME,
        self::PUBLISH_BY,
        self::CREATED_BY,
        self::STATUS,
        self::Pin_status
    ];

    public $translatedAttributes = [
        self::NOTICE_TITLE,
        self::NOTICE_DESCRIPTION
    ];


    public $ownFields = [
        self::NOTICE_TITLE,
        self::NOTICE_DESCRIPTION,
        self::TYPE,
        self::CREATED_BY,
        self::STATUS,
    ];




    public function files()
    {
        return $this->morphMany(Photo::class, 'imageable');

    }



//    public function user()
//    {
//        return $this->belongsTo(User::class,'to_send');
//    }
//
//    public function inboxUser()
//    {
//        return $this->belongsTo(User::class,'from_send');
//    }


}