<?php

namespace App\Models\Site\Payment;

use App\Models\Academic\AcademicFeeType;
use App\Models\Academic\AcademicOnlinePaymentMarchentType;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class PaymentGateway extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_payment_gateways';


    const ACADEMIC_PAYMENT_TYPE_KEY = 'academic_payment_type_key';
    const ACADEMIC_PAYMENT_METHOD_KEY = 'academic_payment_method_key';
    const Academic_fee_type_id = 'academic_fee_type_id';
    const ACADEMIC_ONLINE_PAYMENT_MARCHENT_TYPE_ID = 'academic_online_payment_marchent_type_id';
    const AUTHORIZATION = 'authorization';
    const API_LINK = 'api_link';
    const PARTNER_NUMBER = 'partner_number';
    const USER_NAME = 'user_name';
    const PASSWORD = 'password';
    const PARTNER_CODE = 'partner_code';
    const IID = 'iid';
    const CREATE_URL = 'create_url';
    const EXECUTE_URL = 'execute_url';
    const TOKEN_URL = 'token_url';
    const SCRIPT = 'script';
    const APP_KEY = 'app_key';
    const PROXY = 'proxy';
    const APP_SECRET = 'app_secret';
    const TOKEN = 'token';
    const BRANCH_NAME = 'branch_name';
    const Gateway_details = 'gateway_details';
    const CERATED_DATE = 'created_date';
    const CREATED_BY = 'created_by';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::ACADEMIC_PAYMENT_TYPE_KEY,
        self::ACADEMIC_PAYMENT_METHOD_KEY,
        self::Academic_fee_type_id,
        self::ACADEMIC_ONLINE_PAYMENT_MARCHENT_TYPE_ID,
        self::AUTHORIZATION,
        self::API_LINK,
        self::PARTNER_NUMBER,
        self::USER_NAME,
        self::PASSWORD,
        self::PARTNER_CODE,
        self::IID,
        self::CREATE_URL,
        self::EXECUTE_URL,
        self::TOKEN_URL,
        self::SCRIPT,
        self::APP_KEY,
        self::PROXY,
        self::APP_SECRET,
        self::TOKEN,
        self::BRANCH_NAME,
        self::Gateway_details,
        self::CERATED_DATE,
        self::CREATED_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS
    ];

    public $ownFields = [
        self::ACADEMIC_PAYMENT_TYPE_KEY,
        self::ACADEMIC_PAYMENT_METHOD_KEY , 
        self::Academic_fee_type_id , 
        self::ACADEMIC_ONLINE_PAYMENT_MARCHENT_TYPE_ID,
        self::AUTHORIZATION,
        self::API_LINK,
        self::PARTNER_NUMBER,
        self::USER_NAME,
        self::PASSWORD,
        self::PARTNER_CODE, 
        self::IID, 
        self::CREATE_URL,
        self::EXECUTE_URL,
        self::TOKEN_URL,
        self::SCRIPT,
        self::APP_KEY,
        self::PROXY,
        self::APP_SECRET,
        self::TOKEN,
        self::BRANCH_NAME,
        self::Gateway_details,
        self::CERATED_DATE,
        self::CREATED_BY,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS
    ];

    public function academicOnlinePaymentMethod()
    {
        return $this->belongsTo(AcademicOnlinePaymentMethod::class,'academic_payment_method_key','name_key');
    }
    public function academicOnlinePaymentMarchentType()
    {
        return $this->belongsTo(AcademicOnlinePaymentMarchentType::class,'academic_online_payment_marchent_type_id');
    }

    public function academicFeeType()
    {
        return $this->belongsTo(AcademicFeeType::class,'academic_fee_type_id');
    }
    
}
