<?php

namespace App\Models\Site\Payroll;

use Illuminate\Database\Eloquent\Model;

class SiteEmployeePayroll extends Model
{
    protected $table = 'site_employee_payroll';

    const base_salary =  'base_salary';
    const total_present =  'total_present';
    const total_absent =  'total_absent';
    const total_bonus =  'total_bonus';
    const total_allowance =  'total_allowance';
    const total_deduction =  'total_deduction';
    const year =  'year';
    const month =  'month';
    const pay_date =  'pay_date';

    const total_late = 'total_late';
    const late_status_count = 'late_status_count';
    const absent_count = 'absent_count';
    const unpaid_leave_count = 'unpaid_leave_count';
    const half_day_leave_count = 'half_day_leave_count';
    const total_half_day_leave = 'total_half_day_leave';

    protected $fillable = [
        self::base_salary,
        self::total_bonus,
        self::total_allowance,
        self::total_present,
        self::total_absent,
        self::total_deduction,
        self::unpaid_leave_count,
        self::half_day_leave_count,
        self::total_half_day_leave,
        self::absent_count,
        self::late_status_count,
        self::year,
        self::month,
        self::pay_date,
    ];
    protected $casts = [
        'base_salary' => 'integer',
        'total_present' => 'integer',
        'total_absent' => 'integer',
        'total_bonus' => 'integer',
        'total_allowance' => 'integer',
        'total_deduction' => 'integer',
    ];
    protected $appends = ['gross_pay', 'net_pay',];
    // Accessor for the total revenue
    public function getGrossPayAttribute()
    {
        return ($this->attributes[self::base_salary] + $this->attributes[self::total_bonus]  + $this->attributes[self::total_allowance]);
    }
    public function getNetPayAttribute()
    {
        return $this->getGrossPayAttribute() -  $this->attributes[self::total_deduction];
    }
}
