<?php

namespace App\Models\Site\Progress;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSubject;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteClassSubjectProgressArea extends SiteGlobalModel
{
    protected $table='site_class_subject_progress_areas';

    const Academic_class_id = 'academic_class_id';
    const Academic_subject_id = 'academic_subject_id';
    const Subject_area = 'subject_area';
    const Serial = 'serial';
    const Description = 'description';
    const Status = 'status';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';

    protected $fillable = [
        self::Academic_group_id,
        self::Academic_class_id,
        self::Academic_subject_id,
        self::Subject_area,
        self::Serial,
        self::Description,
        self::Status,
        self::Site_id,
        self::Academic_group_id,
    ];

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class,'academic_class_id');
    }
    
    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class,'academic_subject_id');
    }

}
