<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\Site\Quiz\SiteQuizQuestion;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Quiz\SiteQuiz;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\SiteInfo;

use App\Models\GroupSiteModel;
use App\Models\ProjectModel;

class QuizDeclares extends ProjectModel
{
    protected $table='quiz_declares';

    // const Academic_group_id = 'academic_group_id';
     const Academic_year_id = 'academic_year_id';
    // const Academic_version_id = 'academic_version_id';
    // const Academic_shift_id = 'academic_shift_id';
    // const Academic_department_id = 'academic_department_id';
    // const Academic_class_ids = 'academic_class_ids';
   // const Academic_session_id = 'academic_session_id';
   // const Academic_section_id = 'academic_section_id';
  //  const Academic_class_group_id = 'academic_class_group_id';
    const Site_id = 'site_id';
    const Quiz_id = 'quiz_id';
    const Declare_key = 'declare_key';
    const Question_ids = 'question_ids';
    const Created_by = 'created_by';
    const Status = 'status';

    protected $fillable = [
        self::Academic_year_id,
        self::Site_id,
        self::Quiz_id,
        self::Declare_key,
        self::Question_ids,
        self::Created_by,
        self::Status,

    ];

    protected $ownFields = [
        self::Academic_year_id,
        self::Site_id,
        self::Quiz_id,
        self::Declare_key,
        self::Question_ids,
        self::Created_by,
        self::Status,
    ];


    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }
    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::Academic_shift_id);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    // public function stClass()
    // {
    //     return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    // }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::Academic_class_group_id);
    }
    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::Academic_session_id);
    }

    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }
    public function siteInfo()
    {
        return $this->belongsTo(SiteInfo::class, 'site_id');
    }


    

    public function quiz()
    {
        return $this->belongsTo(SiteQuiz::class,'quiz_id');

    }

    public function quizDeclareSettings()
    {
        return $this->belongsTo(QuizDeclareSettings::class,'id','quiz_declare_id');

    }
    
    public function quizDeclareStudents()
    {
        return $this->hasMany(QuizDeclareStudents::class,'quiz_declare_id');

    }
    public function presentStudent()
    {
        return $this->hasMany(QuizDeclareStudents::class,'quiz_declare_id')->where('join_status',1);

    }

    public function getAcademicClassIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getQuestionIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = SiteQuizQuestion::with(['siteQuizQuestionInfo'=>function($query){
            $query->with('academicClass','academicSubject','academicDepartment','academicSubjectTopic','academicGroup','academicYear','academicExamType');
        },'siteQuizQuestionDetails'])->whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }


}
