<?php

namespace App\Models\Site\Quiz;

use App\Models\Academic\AcademicQuestionLevel;
use App\Models\Image\Photo;
use App\Models\GroupSiteModel;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Dimsav\Translatable\Translatable;


class QuizTopics extends GroupSiteModel
{
    use  Translatable;
    public $translationModel = QuizTopicsTranslation::class;
    public $translationForeignKey = 'quiz_topic_id';

    public $timestamps = true;
    protected $table = 'quiz_topics';
    protected $dates = ['created_at','updated_at'];



    const TOPIC_NAME = 'topic_name';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';

    


    protected $fillable = [

        self::TOPIC_NAME,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];

    public $translatedAttributes = [
        self::TOPIC_NAME,
    ];

    public $ownFields = [
   
        self::TOPIC_NAME,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];



}
