<?php

namespace App\Models\Site\Result\Testimonial;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicResultSystem;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteManuallyTestimonial extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_manually_testimonials';


    const Passing_year = 'passing_year';
    const Student_history_id = 'student_history_id';
    const Academic_result_primary_type_id = 'academic_result_primary_type_id';
    const Grade = 'grade';
    const Gpa = 'gpa';
    const Pass_fail_status = 'pass_fail_status';

    const written_by_show_status = 'written_by_show_status';
    const parents_title_status = 'parents_title_status';
    const printed_date_show = 'printed_date_show';

    const Referance_prefix = 'referance_prefix';
    const Referance_number = 'referance_number';
    const Referance_suffix = 'referance_suffix';

    const Testimonial_created_by = 'testimonial_created_by';
    const Status = 'status';
    const Site_id = 'site_id';




    protected $fillable = [
        self::Passing_year,
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Grade,
        self::Gpa,
        self::Testimonial_created_by,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,

    ];

    public $ownFields = [
        self::Passing_year,
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Grade,
        self::Gpa,
        self::Testimonial_created_by,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,
    ];

    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class);
    }



}
