<?php

namespace App\Models\Site\Result\Testimonial;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicResultSystem;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteTestimonialResult extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_testimonial_result';


    const Passing_year = 'passing_year';
    const Student_history_id = 'student_history_id';
    const Academic_result_primary_type_id = 'academic_result_primary_type_id';
    const Academic_result_combine_type_id = 'academic_result_combine_type_id';
    const Gpa = 'gpa';
    const Academic_result_system_id = 'academic_result_system_id';
    const Pass_fail_status = 'pass_fail_status';

    const Referance_prefix = 'referance_prefix';
    const Referance_number = 'referance_number';
    const Referance_suffix = 'referance_suffix';

    const Testimonial_created_by = 'testimonial_created_by';
    const Status = 'status';
    const Site_id = 'site_id';




    protected $fillable = [
        self::Passing_year,
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Academic_result_combine_type_id,
        self::Gpa,
        self::Academic_result_system_id,
        self::Testimonial_created_by,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,

    ];

    public $ownFields = [
        self::Passing_year,
        self::Student_history_id,
        self::Academic_result_primary_type_id,
        self::Academic_result_combine_type_id,
        self::Gpa,
        self::Academic_result_system_id,
        self::Testimonial_created_by,
        self::Pass_fail_status,
        self::Site_id,
        self::Status,
    ];

    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class);
    }



    public function academicResultSystem()
    {
        return $this->belongsTo(AcademicResultSystem::class);
    }


}
