<?php

namespace App\Models\Site\Routine;

use App\Models\ProjectModel;

class ClassTimingDetail extends ProjectModel
{
    protected $table = 'site_routine_class_timing_details';
    public $timestamps = false;


    protected $casts = [
        'is_break' => 'integer'
    ];


    const CLASS_TIMING_ID = 'class_timing_id';
    const NAME = 'name';
    const START_TIME = 'start_time';
    const END_TIME = 'end_time';
    const IS_BREAK = 'is_break';


    protected $fillabe = [
        self::CLASS_TIMING_ID,
        self::NAME,
        self::START_TIME,
        self::END_TIME,
        self::IS_BREAK
    ];

    public $ownFields = [
        self::NAME,
        self::START_TIME,
        self::END_TIME,
        self::IS_BREAK
    ];


    public function setStartTimeAttribute($value)
    {
        $date = new \DateTime($value);
        return $this->attributes['start_time'] = $date->format('H:i:s');

    }

    public function setEndTimeAttribute($value)
    {
        $date = new \DateTime($value);
        return $this->attributes['end_time'] = $date->format('H:i:s');
    }


    public function classTiming()
    {
        return $this->belongsTo(ClassTiming::class);
    }


    public function routineDetail()
    {
        return $this->hasOne(RoutineDetail::class, 'class_timing_details_id');
    }

}
