<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/3/2016
 * Time: 2:55 PM
 */

namespace App\Models\Site\Routine;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\WeekdayName;
use App\Models\Site\Batch\BatchDetail;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;



class GlobalRoutineDetail extends Model
{

    public $timestamps = true;
    protected $table = 'site_routine_details';


    const START_TIME = 'start_time';
    const END_TIME = 'end_time';
    const IS_BREAK = 'is_break';
    const POSITION = 'position';
    const FIRST_LAST = 'first_last';


    const WEEKDAY = 'weekday';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_PERIOD_TYPE_ID = 'academic_period_type_id';
    const SITE_BATCH_DETAIL_ID = 'site_batch_detail_id';


    protected $fillable = [
        self::START_TIME,
        self::END_TIME,
        self::IS_BREAK,
        self::POSITION,
        self::FIRST_LAST,

        self::WEEKDAY,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,


    ];
    public $ownFields = [
        self::START_TIME,
        self::END_TIME,
        self::IS_BREAK,

        self::WEEKDAY,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,


    ];

    public $copyFields = [
        /* self::START_TIME,
         self::END_TIME,
         self::IS_BREAK,*/

        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,

    ];

    public function getCreatedAtAttribute($date)
    {
        $date = new \Carbon\Carbon($date);
        $date = date("F j, Y, g:i a", strtotime($date));
        return (string)$date;
    }


   /* public function classTimingDetail()
    {
        return $this->belongsTo(ClassTimingDetail::class, 'class_timing_details_id');
    }*/

    public function routineAllocations()
    {
        return $this->hasMany(RoutineAllocation::class, 'routine_details_id');
    }

    public function allocation()
    {
        return $this->hasOne(RoutineAllocation::class, 'routine_details_id');
    }


    public function dept()
    {
        return $this->belongsTo(AcademicDepartment::class, 'academic_department_id');
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function class()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function academicSection()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }

    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }


    public function batch()
    {
        return $this->belongsTo(BatchDetail::class, self::SITE_BATCH_DETAIL_ID);
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, 'academic_class_group_id');
    }

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, 'academic_version_id');
    }

    public function academicYear()//del later
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }

    public function academicShift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }

    public function academicPeriodType()
    {
        return $this->belongsTo(AcademicPeriodType::class, 'academic_period_type_id');
    }

    public function academicSession()
    {
        return $this->belongsTo(AcademicSession::class, 'academic_session_id');
    }


    public function weekDay()
    {
        return $this->belongsTo(WeekdayName::class, 'weekday', 'weekday_key');
    }


}