<?php

namespace App\Models\Site\Routine;

use App\Models\Academic\AcademicSubject;
use App\Models\ProjectModel;
use App\Models\Room\Room;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\SiteGlobalModel;

class RoutineAllocation extends ProjectModel
{

    public $timestamps = true;
    protected $table = 'site_routine_allocations';

    protected $appends = array('employee_name_ex', 'subject_name_ex', 'room_name_ex');


    const ROUTINE_DETAILS_ID = 'routine_details_id';
    const EMPLOYEE_ID = 'employee_id';
    const ROOM_ID = 'room_id';
    const SUBJECT_ID = 'subject_id';


    protected $fillable = [
        self::ROUTINE_DETAILS_ID,
        self::EMPLOYEE_ID,
        self::SUBJECT_ID,
        self::ROOM_ID,

    ];


    public function getEmployeeNameExAttribute()
    {
        return $this->attributes['employee_name_ex'] = ($this->employee->full_name ?? 'Teacher Not Allocated');

    }

    public function getSubjectNameExAttribute()
    {
        return $this->attributes['subject_name_ex'] = ($this->subject->subject_name ?? 'N/A');
    }

    public function getRoomNameExAttribute()
    {
        return $this->attributes['room_name_ex'] = ($this->room->building->building_name ?? '') .' '.($this->room->floor->floor_name ?? '') .'('.($this->room->room_name ?? '').')';

      //  return $this->attributes['room_name_ex'] = $this->room->room_name ?? 'N/A';

    }


    public function attendances()
    {
        return $this->hasMany(PeriodicAttendance::class, 'routine_allocation_id');
    }

    public function routineDetail()
    {
        return $this->belongsTo(RoutineDetail::class, 'routine_details_id');
    }

    public function siteRoutineDetail()
    {
        return $this->belongsTo(SiteRoutineDetail::class, 'routine_details_id');
    }


    public function room()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }


    public function subject()
    {
        return $this->belongsTo(AcademicSubject::class, 'subject_id');
    }


    public function swapCancel()
    {
        return $this->hasOne(RoutineSwapCancel::class, 'allocation_id');
    }

    public function liveMeeting()
    {
        return $this->hasOne(MeetingInvitation::class, 'routine_allocation_id');
    }
}
