<?php

namespace App\Models\Site\Routine;

use App\Models\Academic\AcademicSubject;
use App\Models\SiteGlobalModel;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;

class SubjectWeeklyClass extends SiteGlobalModel
{
    protected $table = 'site_routine_subject_weekly_classes';
    public $timestamps = true;

    protected $casts = [
        'status' => 'integer',
    ];



    public function subject()
    {
        return $this->belongsTo(AcademicSubject::class, 'academic_subject_id');
    }


    public function subGrCondSettings()
    {
        return $this->hasOne(SubjectGroupConditionSetting::class,'academic_subject_id','academic_subject_id');
    }

}
