<?php

namespace App\Models\Site;

use App\Models\Academic\AcademicClass;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteClassSessionSerialSetting extends SiteGlobalModel
{
    protected $table = 'site_class_session_serial_settings';
    public $timestamps = true;

    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const Session_present = 'session_present';
    const Serial_no = 'serial_no';
    const SESSION_IDS = 'session_ids';
    const Status = 'status';


    protected $casts = [
        self::Serial_no => 'integer',
        self::Serial_no => 'integer'
    ];

    protected $fillable = [

        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SESSION_IDS,
        self::Session_present,
        self::Serial_no,
        self::Status,
    ];

    protected $ownField = [

        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SESSION_IDS,
        self::Session_present,
        self::Serial_no,
        self::Status,
    ];


    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }
}
