<?php

namespace App\Models\Site\SiteInfo;

use App\Models\Academic\AcademicShift;
use App\Models\Image\Photo;
use App\Models\Menu\Menu;
use App\Models\Modules\SubModule;
use App\Models\Site\SiteGroup;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteMembership;
use App\Models\Site\SiteType;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GlobalSiteInfo extends Model //real
{
    use SoftDeletes, Translatable; //Translatable,

    public $translationModel = 'App\Models\Site\SiteInfoTranslation';
    public $translationForeignKey = 'site_info_id';

    public $timestamps = false;
    protected $dates = ['deleted_at'];

    protected $table = 'site_infos';

    protected $casts = [
        'site_phone' => 'string',
        'status' => 'integer',
        'st_in_sms' => 'integer',
        'st_out_sms' => 'integer',
        'emp_in_sms' => 'integer',
        'emp_out_sms' => 'integer',
    ];

    /* public function receivesBroadcastNotificationsOn()
     {
         return 'site_infos.'.$this->id;
     }*/
    public $translatedAttributes = [
        self::SITE_NAME,
        //self::SITE_GENDER,
        self::SITE_ADDRESS,
    ];



    const SITE_MEMBERSHIP_ID = 'site_membership_id';
    const SITE_GROUP_ID = 'site_group_id';
    const SITE_NAME = 'site_name';
    const SHORT_NAME = 'short_name';
    const SITE_NAME_NATIVE_LANGUAGE = 'site_name_native_language';
    const Shift_IDs = 'shift_ids';
    const COUNTRY = 'country_id';
    const DIVISION = 'division_id';
    const DISTRICT = 'district_id';
    const ACADEMIC_PERIOD_YPE_IDS = 'academic_period_type_ids';
    const Google_map_address = 'google_map_address';



    const Employee_academic_transport_ids = 'employee_academic_transport_ids';
    const Employee_academic_residence_ids = 'employee_academic_residence_ids';
    const Employee_academic_student_quata_ids = 'employee_academic_student_quata_ids';
    const Emp_grade_ids = 'emp_grade_ids';
    const Employee_examination_ids = 'employee_examination_ids';



    const EIIN = 'eiin';
    const COLLEGE_CODE = 'college_code';
    const NU_CODE = 'nu_code';

    const THANA = 'thana_id';
    const SITE_ADDRESS = 'address';
    const SITE_ALIAS = 'site_alias';
    const SITE_EMAIL = 'site_email';
    const SITE_PHONE = 'site_phone';
    const SITE_LOGO = 'site_logo';
    const ST_IN_SMS = 'st_in_sms';
    const ST_OUT_SMS = 'st_out_sms';
    const EMP_IN_SMS = 'emp_in_sms';
    const EMP_OUT_SMS = 'emp_out_sms';
    const REASON = 'reason';
    const STATUS = 'status';


    const FACEBOOK_LINK = 'facebook_link';
    const TWITTER_LINK = 'twitter_link';
    const GOOGLE_LINK = 'google_link';
    const YOUTUBE_LINK = 'youtube_link';
    const Web_student_fee_collection_status = 'web_student_fee_collection_status';
    const Admission_fee_collection_status = 'admission_fee_collection_status';
    const Admission_fee_paid_sms = 'admission_fee_paid_sms';
    const Website_result_show_by_username = 'website_result_show_by_username';
    const Show_subhead_in_payment_slip = 'show_subhead_in_payment_slip';


    protected $fillable = [
        self::SITE_MEMBERSHIP_ID,
        self::SITE_GROUP_ID,
        self::SITE_NAME,
        self::SHORT_NAME,
        self::Shift_IDs,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::Google_map_address,
        self::SITE_NAME_NATIVE_LANGUAGE,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
   
        self::FACEBOOK_LINK,
        self::TWITTER_LINK,
        self::GOOGLE_LINK,
        self::YOUTUBE_LINK,

        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,

        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::SITE_ADDRESS,
        self::SITE_ALIAS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::SITE_LOGO,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::REASON,
        self::STATUS,
        self::Web_student_fee_collection_status,
        self::Admission_fee_collection_status,
        self::Admission_fee_paid_sms,
        self::Website_result_show_by_username,
        self::Show_subhead_in_payment_slip,
    ];

    public $ownfields = [

        self::SITE_MEMBERSHIP_ID,
        self::SITE_GROUP_ID,
        self::Shift_IDs,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::Google_map_address,
        self::SITE_NAME_NATIVE_LANGUAGE,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,
        self::SITE_ALIAS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::SITE_LOGO,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::REASON,
        self::STATUS,

        self::FACEBOOK_LINK,
        self::TWITTER_LINK,
        self::GOOGLE_LINK,
        self::YOUTUBE_LINK,
        self::Web_student_fee_collection_status,
        self::Admission_fee_collection_status,
        self::Admission_fee_paid_sms,
        self::Website_result_show_by_username,
    ];
    public  function scopeActive($query)
    {
        return $query->where('status',1);
    }
    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function siteType()
    {
        return $this->belongsTo(SiteType::class);
    }

    public function siteMembership()
    {
        return $this->hasOne(SiteMembership::class, 'site_id')->where('status',true);
    }

    public function menus()
    {
        return $this->belongsToMany(Menu::class,'site_accesses','site_id','menu_id');
    }


    public function siteGroup()
    {
        return $this->belongsTo(GlobalSiteInfo::class);
    }


    public function subModules()
    {
        return $this->belongsToMany(SubModule::class, 'site_accesses', 'site_id', 'sub_module_id');
    }

    public function siteInfoSettings()
    {
        return $this->hasMany(GlobalSiteInfoSetting::class, 'site_id');
    }



    public function getShiftIdsAttribute($values)
    {
        // dd(explode(',', $values));

        return $this->attributes['shift_ids'] = AcademicShift::whereIn('id', explode(',', $values))->get();

        // $this->attributes['password'] = bcrypt($request);


    }



}
