<?php

namespace App\Models\Site\SiteInfoSetting;

use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicGroup;
use App\Models\Site\SiteInfo;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteInfoSetting extends SiteGlobalModel
{


    public $timestamps = true;
    protected $dates = ['deleted_at'];
    public $table = 'site_info_settings';


    protected $casts=[
        'st_in_sms'=>'integer',
        'st_out_sms'=>'integer',
    ];


    const Site_Group_Setting_ID = 'site_group_setting_id';
    const Academic_Group_ID = 'academic_group_id';
    const SITE_ID = 'site_id';


    const ACADEMIC_VERSION_IDs = 'academic_version_ids';
    const ACADEMIC_YEAR_IDs = 'academic_year_ids';
    const ACADEMIC_SESSION_IDs = 'academic_session_ids';
    const ACADEMIC_SESSION_TYPE_IDs = 'academic_session_type_ids';
    const ACADEMIC_STUDENT_CATEGORY_IDs = 'academic_student_category_ids';
    const ACADEMIC_ADMISSION_TYPE_IDs = 'academic_admission_type_ids';
    const ACADEMIC_STUDENT_TYPE_IDs = 'academic_student_type_ids';

    const Academic_Class_IDs = 'academic_class_ids';
    const Academic_Department_IDs = 'academic_department_ids';
    const Academic_Subject_IDs = 'academic_subject_ids';
    const Academic_Section_IDs = 'academic_section_ids';
    const Academic_Class_Group_IDs = 'academic_class_group_ids';
    const Academic_Subject_Condition_IDs = 'academic_subject_condition_ids';
    const Shift_IDs = 'shift_ids';
    const Gender_IDs = 'gender_ids';
    const SITE_GOVT_CODE = 'site_govt_code';
    const Religion_IDs = 'religion_ids';
    const Academic_Residence_IDs = 'academic_residence_ids';
    const STATUS = 'status';
    const Emp_exam_committee_position_ids = 'emp_exam_committee_position_ids';
    const ACADEMIC_RESULT_GRADE_IDs = 'academic_result_grade_ids';

    const Academic_result_primary_type_ids = 'academic_result_primary_type_ids';
    const Academic_result_combine_type_ids = 'academic_result_combine_type_ids';
    const Academic_subject_class_exam_condition_id = 'academic_subject_class_exam_condition_id';
    const ST_IN_SMS = 'st_in_sms';
    const ST_OUT_SMS = 'st_out_sms';
    const PRESENT_SMS_TEXT = 'present_sms_text';
    const Batch_present_status = 'batch_present_status';
    const EMP_IN_SMS = 'emp_in_sms';
    const EMP_OUT_SMS = 'emp_out_sms';
    const Regards_title = 'regards_title';


    protected $fillable = [
        self::Site_Group_Setting_ID,
        self::SITE_ID,
        self::Academic_Group_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_ADMISSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::Site_Group_Setting_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
        self::ACADEMIC_RESULT_GRADE_IDs,

        self::Emp_exam_committee_position_ids,
        self::Academic_result_primary_type_ids,
        self::Academic_result_combine_type_ids,
        self::Academic_subject_class_exam_condition_id,
        self::Batch_present_status,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::Regards_title,
    ];

    public $ownFields = [
        self::Site_Group_Setting_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_ADMISSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::SITE_ID,
        self::Site_Group_Setting_ID,
        self::Academic_Group_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::ST_IN_SMS,
        self::ST_OUT_SMS,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
        self::ACADEMIC_RESULT_GRADE_IDs,
        self::Emp_exam_committee_position_ids,
        self::Academic_result_primary_type_ids,
        self::Academic_result_combine_type_ids,
        self::Academic_subject_class_exam_condition_id,
        self::Batch_present_status,
        self::EMP_IN_SMS,
        self::EMP_OUT_SMS,
        self::Regards_title,
    ];


    public  function academicGroup(){
        return $this->belongsTo(AcademicGroup::class,'academic_group_id','id');

    }
    public  function site()
    {
        return $this->belongsTo(SiteInfo::class, 'site_id');
    }

}
