<?php

namespace App\Models\Site\Sms;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SitePhoneBook extends ProjectModel
{
    public $timestamps = true;
    protected $table = 'site_phone_books';

    protected $casts = ['status' => 'integer'];

    const MOBILE_NUMBER = 'mobile_number';
    const NAME = 'name';
    const ADDRESS = 'address';
    const CREATED_BY = 'created_by';
    const STATUS = 'status';
    const Group_name = 'group_name';


    protected $fillable = [
        self::MOBILE_NUMBER,
        self::NAME,
        self::ADDRESS,
        self::CREATED_BY,
        self::STATUS,
        self::Group_name
    ];


    public $ownFields = [
        self::MOBILE_NUMBER,
        self::NAME,
        self::ADDRESS,
        self::CREATED_BY,
        self::STATUS,
        self::Group_name
    ];

}
