<?php

namespace App\Models\Site\Student\Attendance;

use App\Models\Site\Student\GlobalStudentHistory;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GlobalLeaveDetail extends Model
{
    protected $table = 'site_student_attendance_leave_details';
    public $timestamps = true;

    protected $casts = [
        'status' => 'integer'
    ];

    const STUDENT_HISTORY_ID = 'student_history_id';
    const STATUS = 'status';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::STATUS,
    ];


    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class, 'student_history_id');
    }


    public function scopeLeaveToday($query)
    {
        $today_date = Carbon::now()->toDateString();

        return $query->where('leave_date', $today_date);
    }

}
