<?php

namespace App\Models\Site\Student\Attendance;

use App\Models\Site\Student\Student;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class StudentLeave extends SiteGlobalModel
{
    protected $table = 'site_student_attendance_leaves';
    public $timestamps = true;

    protected $casts = [
        'status' => 'integer'
    ];


    const STUDENT_HISTORY_ID = 'student_history_id';
    const TO_DATE = 'to_date';
    const FROM_DATE = 'from_date';
    const TOTAL_DAYS = 'total_days';
    const LEAVE_REASON = 'leave_reason';
    const CANCEL_REASON = 'cancel_reason';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::TO_DATE,
        self::FROM_DATE,
        self::TOTAL_DAYS,
        self::LEAVE_REASON,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::TO_DATE,
        self::FROM_DATE,
        self::TOTAL_DAYS,
        self::LEAVE_REASON,
    ];


    public $updateFields = [
        self::TO_DATE,
        self::FROM_DATE,
        self::TOTAL_DAYS,
        self::LEAVE_REASON,
    ];


    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, 'student_history_id');
    }

    public function approvedBy()
    {
        return $this->belongsTo(GlobalUser::class, 'approved_cancelled_by');
    }

    public function leaveDetails()
    {
        return $this->hasMany(StudentLeaveDetail::class, 'site_student_attendance_leave_id');
    }


}
