<?php

namespace App\Models\Site\Student\Manual;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;

class GlobalStudentManualCount extends Model
{
    protected $table = 'site_student_manual_counts';
    const site_group_id = 'site_group_id';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const SITE_BATCH_DETAIL_ID = 'site_batch_detail_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const TOTAL_NUMBER_OF_STUDENT = 'total_number_of_studnet';
    const TOTAL_NUMBER_OF_MALE_STUDENT = 'total_number_of_male_studnet';
    const TOTAL_NUMBER_OF_FEMALE_STUDENT = 'total_number_of_female_studnet';


protected $fillable = [
    self::ACADEMIC_GROUP_ID,
    self::ACADEMIC_VERSION_ID,
    self::ACADEMIC_SHIFT_ID,
    self::ACADEMIC_YEAR_ID,
    self::ACADEMIC_SESSION_ID,
    self::ACADEMIC_CLASS_ID,
    self::ACADEMIC_CLASS_GROUP_ID,
    self::SITE_BATCH_DETAIL_ID,
    self::ACADEMIC_DEPARTMENT_ID,
    self::ACADEMIC_SECTION_ID,
    self::TOTAL_NUMBER_OF_STUDENT,
    self::TOTAL_NUMBER_OF_MALE_STUDENT,
    self::TOTAL_NUMBER_OF_FEMALE_STUDENT,

];

public $ownFields = [
    self::ACADEMIC_GROUP_ID,
    self::ACADEMIC_VERSION_ID,
    self::ACADEMIC_SHIFT_ID,
    self::ACADEMIC_YEAR_ID,
    self::ACADEMIC_SESSION_ID,
    self::ACADEMIC_CLASS_ID,
    self::ACADEMIC_CLASS_GROUP_ID,
    self::SITE_BATCH_DETAIL_ID,
    self::ACADEMIC_DEPARTMENT_ID,
    self::ACADEMIC_SECTION_ID,
    self::TOTAL_NUMBER_OF_STUDENT,
    self::TOTAL_NUMBER_OF_MALE_STUDENT,
    self::TOTAL_NUMBER_OF_FEMALE_STUDENT,
];


    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::ACADEMIC_DEPARTMENT_ID);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }


    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function accGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::ACADEMIC_CLASS_GROUP_ID);
    }

    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::ACADEMIC_SESSION_ID);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class,'academic_year_id');
    }

    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }

};
