<?php

namespace App\Models\Site\StudentAdmission;

use Illuminate\Database\Eloquent\Model;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicBoard;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Gender\Gender;
use App\Models\Relation\Relation;
use App\Models\Religion\Religion;
use App\Models\Site\SiteInfo;
use App\Models\Thana\Thana;
use App\Models\User\User;

class GlobalSiteStudentAdmissionBoardApprove extends Model
{
    protected $table='site_student_admission_board_approves';

    const Site_student_admission_declare_id = 'site_student_admission_declare_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_session_id = 'academic_session_id';
    const Board_roll_number = 'board_roll_number';
    const Academic_board_id = 'academic_board_id';
    const Board_registration_number = 'board_registration_number';
    const Passing_year = 'passing_year';
    const First_name = 'first_name';
    const Father_name = 'father_name';
    const Mother_name = 'mother_name';
    const Contact_number = 'contact_number';

    const Admission_fee = 'admission_fee';
    const Total_admission_fee = 'total_admission_fee';
    const Other_fee = 'other_fee';
    const Waiver_amount = 'waiver_amount';
    const Total_fee_with_other = 'total_fee_with_other';
    const Transaction_number = 'transaction_number';
    const Second_transaction_number = 'second_transaction_number';
    const Admission_status = 'admission_status';
    const Payment_status = 'payment_status';
    const Second_payment_status = 'second_payment_status';
    const Created_by = 'created_by';
    const Tr_amount = 'tr_amount';
    const Second_tr_amount = 'second_tr_amount';
    const Bank_name = 'bank_name';
    const Payment_date = 'payment_date';
    const Payment_time = 'payment_time';
    const Paid_by = 'paid_by';
    const IID = 'iid';
    const Random_number = 'random_number';
    const Invoice_no = 'invoice_no';
    const Online_payment_status = 'online_payment_status';

    const Edu_service_charge_percentage_status = 'edu_service_charge_percentage_status';
    const Edu_service_charge_amount = 'edu_service_charge_amount';
    const Bank_service_charge_percentage = 'bank_service_charge_percentage';
    const Bank_service_charge_amount = 'bank_service_charge_amount';

    const Site_id = 'site_id';
    const Status = 'status';

    protected $fillable = [
        self::Academic_group_id,
        self::Site_student_admission_declare_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Board_roll_number,
        self::Academic_board_id,
        self::Board_registration_number,
        self::Passing_year,
        self::First_name,
        self::Father_name,
        self::Mother_name,

        self::Admission_fee,
        self::Total_admission_fee,
        self::Contact_number,
        self::Other_fee,
        self::Waiver_amount,
        self::Total_fee_with_other,
        self::Transaction_number,
        self::Second_transaction_number,
        self::Payment_status,
        self::Second_payment_status,
        self::Admission_status,
        self::IID,
        self::Created_by,
        self::Tr_amount,
        self::Second_tr_amount,
        self::Bank_name,
        self::Payment_date,
        self::Payment_time,
        self::Paid_by,
        self::Random_number,
        self::Invoice_no,
        self::Online_payment_status,

        self::Edu_service_charge_percentage_status,
        self::Edu_service_charge_amount,
        self::Bank_service_charge_percentage,
        self::Bank_service_charge_amount,

        self::Site_id,
        self::Status,
    ];



    protected $ownFields = [
        self::Academic_group_id,
        self::Site_student_admission_declare_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Board_roll_number,
        self::Academic_board_id,
        self::Board_registration_number,
        self::Passing_year,
        self::First_name,
        self::Father_name,
        self::Mother_name,
        self::Online_payment_status,

        self::Admission_fee,
        self::Waiver_amount,
        self::Total_fee_with_other,
        self::Transaction_number,
        self::Second_transaction_number,
        self::Payment_status,
        self::Admission_status,
        self::IID,
        self::Created_by,
        self::Tr_amount,
        self::Second_tr_amount,
        self::Bank_name,
        self::Payment_date,
        self::Payment_time,
        self::Paid_by,
        self::Random_number,
        self::Invoice_no,

        self::Edu_service_charge_percentage_status,
        self::Edu_service_charge_amount,
        self::Bank_service_charge_percentage,
        self::Bank_service_charge_amount,

        self::Site_id,
        self::Status,
    ];

    
    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::Academic_shift_id);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, self::Academic_class_id);
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::Academic_class_group_id);
    }
    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::Academic_session_id);
    }
    public function site()
    {
        return $this->belongsTo(SiteInfo::class, self::Site_id);
    }

    public function academicBoard()
    {
        return $this->belongsTo(AcademicBoard::class, self::Academic_board_id);
    }

    public function siteStudentAdmissionDeclare()
    {
        return $this->belongsTo(GlobalSiteStudentAdmissionDeclare::class, self::Site_student_admission_declare_id);
    }

  


}
